# Player: huggingface_DeepSeek-V3-0324_PayoffMaximizer_B (as Player B)
# Meta-Round: 10
# Experiment: PMxPM, Run: 4
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek_V3_0324_PayoffMaximizer_B_MR10_strategy.txt
# LLM Suggested Fallback: D

def huggingface_DeepSeek_V3_0324_PayoffMaximizer_B_MR10(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    current_round = len(my_history) + 1
    total_rounds = 10
    
    # Check for unconditional strategies in opponent's code
    always_c = "return 'C'" in opponent_program_code or "return 'c'" in opponent_program_code
    always_d = "return 'D'" in opponent_program_code or "return 'd'" in opponent_program_code
    
    if always_c or always_d:
        return "D"  # Exploit unconditional strategies
    
    # Initial move: Cooperate
    if current_round == 1:
        return "C"
    
    # Check for opponent's defections in the last round
    if opp_history[-1] == "D":
        return "D"  # Tit-for-tat retaliation
    
    # Randomized defection with 10% chance
    if random.random() < 0.1:
        return "D"
    
    # Final rounds: defect if opponent has defected more than twice
    if current_round >= total_rounds - 1:
        if opp_history.count("D") > 2:
            return "D"
    
    # Default to cooperation
    return "C"